import logging

from kubiki.util import make_requests_session


LOGGER = logging.getLogger(__name__)


class BinResolverResponse(object):

    def __init__(self, name, icon_url):
        self.name = name
        self.icon_url = icon_url

    def to_dict(self):
        return {
            'name': self.name,
            'icon_url': self.icon_url,
        }


class BinResolver(object):

    def __init__(self):
        self._session = make_requests_session()

    def resolve(self, bin_):
        url = self._get_sexy_bergusman_url(bin_)
        response = self._session.get(url, timeout=3)
        response.raise_for_status()

        try:
            data = response.json()
            rocket_data = data['bin']['rocket']
        except (KeyError, ValueError):
            LOGGER.exception('failed to parse sexy bergusman response: %s', repr(response.content))
            return None

        if rocket_data is None:
            return None

        name = rocket_data.get('name')
        icon_url = rocket_data.get('icon_url')
        if name is None or icon_url is None:
            return None

        return BinResolverResponse(
            name=name,
            icon_url=icon_url,
        )

    def _get_sexy_bergusman_url(self, bin_):
        return 'https://bergusman.sexy/drive/api/bins/{}'.format(bin_)
