from rest_framework.response import Response

from ..core.bin_resolver import BinResolver
from ..serializers.bin_resolver import BinResolverArgumentsSerializer
from .base import UtilAPIView


class BinResolverView(UtilAPIView):

    arguments_serializer_class = BinResolverArgumentsSerializer

    bin_resolver = BinResolver()

    def do_get(self, request):
        bin_ = request.arguments['bin']
        result = self.bin_resolver.resolve(bin_)
        return Response({
            'data': result.to_dict() if result else None,
        })
