#!/usr/bin/env python3
import json
import os
import sys

import requests
import shapely.geometry


CITIES = [
    (1, 'msk'),
    (2, 'spb'),
    (157, 'minsk'),
    (10398, 'budapest'),
]


def main():
    if len(sys.argv) != 2:
        print('usage: {} out_dir'.format(sys.argv[0]))
        return

    out_dir = sys.argv[1]

    for geoid, city_code in CITIES:
        print('processing {}'.format(city_code))
        r = requests.get('http://localhost:8000/aggregator/api/carsharing/operators/', headers={'City': str(geoid)})
        for operator in r.json():
            operator_code = operator['short_name']
            area_geojson = operator['area']
            area_shape = shapely.geometry.shape(area_geojson)
            area_wkt = area_shape.wkt

            path = os.path.join(out_dir, city_code, operator_code)
            path_geojson = path + '.json'
            path_wkt = path + '.wkt'
            os.makedirs(os.path.dirname(path), exist_ok=True)

            with open(path_geojson, 'w') as f:
                print('writing {}'.format(path_geojson))
                json.dump(area_geojson, f, ensure_ascii=False)
            with open(path_wkt, 'w') as f:
                print('writing {}'.format(path_wkt))
                f.write(area_wkt)


if __name__ == '__main__':
    main()
