#!/usr/bin/env python3
import requests
import shapely.geometry

r = requests.get('https://belkacar.ru/map-info?active_rent_id=')
data = r.json()
zones = data['map_info']['area']['geozones_to_finish']
polygons = [shapely.geometry.Polygon([(c['lng'], c['lat']) for c in zone[0]]) for zone in zones]
area = shapely.geometry.MultiPolygon(polygons)
print(area.wkt)
