#!/usr/bin/env python3
import json

import requests
import shapely.geometry


def main():
    r = requests.get('https://car5.ru/car5/rs/pump.get_poligons.php')
    data = r.json()[0]['data']
    coords = json.loads(data[0]['value'])[0][0]
    coords = [(lon, lat) for lat, lon in coords]
    polygon = shapely.geometry.Polygon(coords)
    print(polygon.wkt)


if __name__ == '__main__':
    main()
