#!/usr/bin/env python3
import requests
import shapely.geometry


def main():
    r = requests.get('https://rentmee.club/version3/public/geozones_json.cfm')
    data = r.json()
    ends = data['data']['ENDS']

    polygons = {
        'msk': [],
        'spb': [],
    }

    for poly in ends:
        coords = [(p['LG'], p['LT']) for p in poly['POLYGON']]

        if coords[0][0] > 33:
            city = 'msk'
        else:
            city = 'spb'

        polygon = shapely.geometry.Polygon(coords)
        polygons[city].append(polygon)

    areas = {k: shapely.geometry.MultiPolygon(v) for k, v in polygons.items()}
    for city, area in areas.items():
        print(city)
        print(area.wkt)


if __name__ == '__main__':
    main()
