#!/usr/bin/env python3
import requests
import shapely.geometry

r = requests.get('https://urentcar.cartrek.online/api/zones/rentEnd')
data = r.json()
zones = data['rentEndZones']
polygons = [shapely.geometry.Polygon([(c[0], c[1]) for c in zone['points']]) for zone in zones]
area = shapely.geometry.MultiPolygon(polygons)
print(area.wkt)
