#!/usr/bin/env python3
import json
import os
import sys

import shapely.geometry

def main():
    with open(sys.argv[1]) as f:
        area_geojson = json.load(f)
    
    shape = shapely.geometry.MultiPolygon([shapely.geometry.shape(f['geometry']) for f in area_geojson['features'] if f['geometry']['type'] == 'Polygon'])
    effective = os.path.join(
        os.path.dirname(os.path.realpath(__file__)),
        '../cars/carsharing/core/resources/parking_area_effective.wkt'
    )
    visible = os.path.join(
        os.path.dirname(os.path.realpath(__file__)),
        '../cars/carsharing/core/resources/parking_area_visible.wkt'
    )

    with open(effective, 'w') as f:
        f.write(shape.wkt)

    with open(visible, 'w') as f:
        f.write(shape.wkt)

if __name__ == '__main__':
    main()
