#!/usr/bin/env python
from setuptools import setup, find_packages

setup(
    name='cars',
    version='1.0',
    description='Yandex.Drive',
    author='Ales Mikholap',
    author_email='carabas@yandex-team.ru',
    packages=find_packages(),
    package_data={
        'cars': [
            'carsharing/core/resources/*.wkt',
            'contrib/*.so',
            'core/parking_areas/static/*.wkt',
            'messages/*/LC_MESSAGES/*.mo',
            'registration/core/resources/*.json',
            'registration/core/resources/*.yml',
        ],
    },
    install_requires=[
        # 'blackbox==0.57',
        'django-idm-api==2.12.4',
        'django-yauth==4.3',
        'kubiki==1.38',
        'planex',
        'saaspy==0.0.52',
        'solomon==1.8',
        'ticket-parser2',
        'yandex-yt==0.8.43',
        'yandex-yt-yson-bindings==0.3.9.post0',
        'siphash==0.0.1',

        'attrdict==2.0.0',
        'boto3==1.4.7',
        'cryptography==2.1.2',
        'Django==2.0.3',
        'django-db-constraints==0.3.0',
        'django-phonenumber-field==1.3.0',
        'django-rest-swagger==2.1.2',
        'djangorestframework==3.7.7',
        'factory-boy==2.10.0',
        'ffprobe3==0.1.2',
        'ffmpy==0.2.2',
        'furl==1.0.0',
        'gevent==1.2.2',
        'hammock==0.2.4',
        'haversine==0.4.5',
        'kazoo==2.2.1',
        'lxml==4.1.1',
        'Markdown==2.6.8',
        'openpyxl==2.5.5',
        'packaging==17.1',
        'pandas==0.21.0',
        'paramiko==2.4.2',
        'Pillow==4.3.0',
        'psycopg2==2.7.3',
        'PyCRC==1.21',
        'pymorphy2==0.8',
        'PyNaCl==1.3.0',
        'pytils==0.3',
        'PyYAML==3.12',
        'raven==6.0.0',
        'requests==2.18.4',
        'retry==0.9.2',
        'Rtree==0.8.3',
        'Shapely==1.6b4',
        'simplejson==3.13.2',
        'Twisted==17.9.0',
        'unicodecsv==0.14.1',
        'uWSGI==2.0.14',
        'xlrd==1.1.0',
        'Pygments==2.3.1',
        'ipython==6.5.0',
        'protobuf==3.6.1',
        'PyJWT==1.7.1',
        'yql==1.2.83',
        'colorama==0.4.1',
        'six==1.12.0',
    ],
    dependency_links=[
        'https://github.yandex-team.ru/vanish/vanish-planex/tarball/master#egg=planex-0.0.2',
        'https://pypi.yandex-team.ru/repo/default/',
    ],
)
