import logging
import requests
from drive.qatool.tus.tus import TestUserService as tus

LOGGER = logging.getLogger(__name__)


class TusClient:
    def __init__(self, token, base_url="https://tus.yandex-team.ru",
                 ):
        self.base_url = base_url
        self.token = token

    def _request(self, path, data=None, method='GET', params=None):
        url = self.base_url + path
        session = requests.session()
        session.headers.update({"Authorization": "OAuth {}".format(self.token)})
        try:
            response = session.request(url=url, data=data, method=method, params=params)
            response.raise_for_status()
            response = response.json()
            logging.debug(response)
        except requests.exceptions.RequestException as e:
            logging.error("error: {} {}".format(e.request, e.response))
            raise
        return response

    def create_account(self, login, password=None, firstname=None, lastname=None,
                       language=None, country=None, tags=None, tus_consumer=None, env="prod"):
        path = "/1/create_account/portal/"
        data = {"env": env}
        payload = {'login': login, 'password': password, 'firstname': firstname, 'lastname': lastname,
                   'language': language,
                   'country': country, 'tags': tags, 'tus_consumer': tus_consumer}
        r = self._request(path=path, params=payload, data=data, method='POST')
        return tus.from_json(r["account"])

    def get_account(self, tus_consumer, uid=None,
                    login=None, tags=None, env=None,
                    ignore_locks=None, lock_duration=None,
                    with_saved_tags=None, ):
        path = "/1/get_account/"
        payloads = {
            'uid': uid,
            'login': login,
            'tags': tags,
            'env': env,
            'ignore_locks': ignore_locks,
            'lock_duration': lock_duration,
            'with_saved_tags': with_saved_tags,
            'tus_consumer': tus_consumer
        }
        response = self._request(path=path, params=payloads, method='GET')
        return tus.from_json(response['account'])

    def unlock_account(self,uid, tus_consumer=None, env=None):
        path = "/1/unlock_account/"
        payloads = {
            'uid': uid,
            'env': env,
            'tus_consumer': tus_consumer,
        }
        response = self._request(path=path, params=payloads, method='POST')
        return response
