package api

import (
	"net/url"
	"os"
	"path"
	"path/filepath"

	"github.com/labstack/echo/v4"
	"github.com/labstack/echo/v4/middleware"

	"a.yandex-team.ru/drive/library/go/echolog"
	"a.yandex-team.ru/drive/runner/core"
	"a.yandex-team.ru/drive/runner/front"
	"a.yandex-team.ru/drive/runner/models"
)

func NewServer(c *core.Core) (*echo.Echo, error) {
	if c == nil {
		panic("core should not be nil")
	}
	s := echo.New()
	s.HideBanner, s.HidePort = true, true
	if c.Solomon != nil {
		s.Use(echolog.Solomon(c.Solomon, "server"))
	}
	s.Use(
		echolog.Logger(c.Logger("server")),
		middleware.Recover(),
		middleware.Gzip(),
	)
	s.Pre(middleware.RemoveTrailingSlash())
	if dir := c.Config.Server.StaticDir; dir != "" {
		s.Group("").Any("/*", func(c echo.Context) error {
			p, err := url.PathUnescape(c.Param("*"))
			if err != nil {
				return err
			}
			name := filepath.Join(dir, path.Clean("/"+p))
			if _, err := os.Stat(name); os.IsNotExist(err) {
				return c.File(filepath.Join(dir, "index.html"))
			}
			return c.File(name)
		})
	}
	v := NewView(c)
	v.Register(s.Group("/api"))
	// Deprecated.
	s.Static("/old-static", c.Config.Server.OldStaticDir)
	middlewares := []echo.MiddlewareFunc{
		v.sessionAuth,
		v.requirePermission(models.LegacyAuthPermission),
	}
	front.NewView(c).Register(s, middlewares)
	return s, nil
}
