# -*- coding: utf-8 -*-

from json import dumps
from six import PY2
from os.path import abspath
from requests_unixsocket import Session


if PY2:
    from urllib import quote
else:
    from urllib.parse import quote


class Socket(object):
    def __init__(self, path="dajr.sock"):
        self._path = path
        self._session = Session()

    def create_resource(
        self, data, dir_id=0, title="", meta=None,
    ):
        response = self._session.post(
            "http+unix://{}/resources".format(
                quote(abspath(self._path), safe=""),
            ),
            files=dict(Data=data),
            params=dict(
                DirID=str(dir_id),
                Title=title,
                Meta=dumps(meta or dict()),
            ),
        )
        response.raise_for_status()
        return response.json()

    def get_resource(self, resource_id):
        response = self._session.get(
            "http+unix://{}/resources/{}".format(
                quote(abspath(self._path), safe=""),
                resource_id,
            ),
        )
        response.raise_for_status()
        return response.json()

    def get_resource_data(self, resource_id):
        response = self._session.get(
            "http+unix://{}/resources/{}/data".format(
                quote(abspath(self._path), safe=""),
                resource_id,
            ),
        )
        response.raise_for_status()
        return response.content
