CREATE TABLE "host" (
    "id" serial not null constraint host_pk primary key,
    "name" character varying(255) NOT NULL,
    "ping_time" bigint NOT NULL,
    "config" jsonb NOT NULL,
    "state" jsonb NOT NULL
);
CREATE UNIQUE INDEX "host_name_idx" on "host" ("name");


CREATE TABLE "planner" (
    id serial not null constraint planner_pk primary key,
    action_id integer NOT NULL,
    owner_id integer,
    title character varying(255) NOT NULL,
    description text NOT NULL,
    options jsonb NOT NULL,
    settings jsonb NOT NULL,
    dir_id integer,
    create_time bigint NOT NULL
);

CREATE TABLE "planner_event"
(
    "event_id" bigserial not null constraint "planner_event_pk" primary key,
    "event_type" character varying(16) NOT NULL,
    "event_time" bigint NOT NULL,
    "event_user_id" bigint,
    "event_task_id" bigint,
    "id" integer NOT NULL,
    "action_id" integer NOT NULL,
    "owner_id" integer,
    "title" character varying(255) NOT NULL,
    "description" text NOT NULL,
    "options" jsonb NOT NULL,
    "settings" jsonb NOT NULL,
    "dir_id" integer,
    "create_time" bigint NOT NULL
);
CREATE INDEX "planner_event_id_idx" ON "planner_event" ("id");


CREATE TABLE "task" (
    id serial not null constraint task_pk primary key,
    action_id integer NOT NULL,
    owner_id integer,
    node_id integer,
    create_time bigint DEFAULT (date_part('epoch'::text, CURRENT_TIMESTAMP))::bigint NOT NULL,
    options jsonb DEFAULT '{}'::jsonb NOT NULL,
    status character varying(32) DEFAULT 'Queued'::character varying NOT NULL,
    update_time bigint DEFAULT (date_part('epoch'::text, CURRENT_TIMESTAMP))::bigint NOT NULL,
    planner_id integer
);

CREATE TABLE "task_log" (
    id bigserial not null constraint task_log_pk primary key,
    task_id integer NOT NULL,
    type character varying(32),
    lines text NOT NULL,
    create_time bigint DEFAULT (date_part('epoch'::text, CURRENT_TIMESTAMP))::bigint NOT NULL
);

CREATE TABLE "lock" (
    id serial not null constraint lock_pk primary key,
    name varchar(255) not null,
    host_id integer constraint lock_host_id_fk references host,
    ping_time bigint not null
);
CREATE UNIQUE INDEX lock_name_idx on lock (name);
INSERT INTO lock (name, host_id, ping_time) VALUES ('leader', null, 0);

CREATE TABLE "account" (
    "id" serial not null constraint "account_pk" primary key,
    "kind" integer NOT NULL,
    "login" character varying(255) NOT NULL,
    passport_uid bigint,
    create_time bigint NOT NULL
);
CREATE UNIQUE INDEX "account_passport_uid_idx" ON "account" ("passport_uid");

CREATE TABLE "account_event" (
    event_id bigserial not null constraint account_event_pk primary key,
    event_type character varying(16) NOT NULL,
    event_time bigint NOT NULL,
    event_user_id bigint,
    event_task_id bigint,
    id bigint NOT NULL,
    "kind" integer NOT NULL,
    "login" character varying(255) NOT NULL,
    passport_uid bigint,
    create_time bigint NOT NULL
);
CREATE INDEX account_event_id_idx ON account_event (id);


CREATE TABLE "action" (
    id serial not null constraint action_pk primary key,
    title character varying(255) NOT NULL,
    description text NOT NULL,
    options jsonb NOT NULL,
    create_time bigint NOT NULL,
    owner_id bigint,
    dir_id bigint,
    parent_id bigint
);
CREATE TABLE action_event
(
    event_id bigserial not null constraint action_event_pk primary key,
    event_type character varying(16) NOT NULL,
    event_time bigint NOT NULL,
    event_user_id bigint,
    event_task_id bigint,
    id bigint NOT NULL,
    parent_id bigint,
    dir_id bigint,
    owner_id bigint,
    create_time bigint NOT NULL,
    options jsonb NOT NULL,
    title character varying(255) NOT NULL,
    description text NOT NULL
);
CREATE INDEX action_event_id_idx ON action_event (id);

CREATE TABLE secret
(
    id serial not null constraint secret_pk primary key,
    dir_id bigint,
    title character varying(255) NOT NULL,
    type character varying(32) NOT NULL,
    data jsonb NOT NULL
);
CREATE TABLE secret_event
(
    event_id bigserial not null constraint secret_event_pk primary key,
    event_type character varying(16) NOT NULL,
    event_time bigint NOT NULL,
    id bigint NOT NULL,
    dir_id bigint,
    title character varying(255) NOT NULL,
    type character varying(32) NOT NULL,
    data jsonb NOT NULL,
    event_user_id bigint,
    event_task_id bigint
);
CREATE INDEX secret_event_id_idx ON secret_event (id);

CREATE TABLE config
(
    id serial not null constraint config_pk primary key,
    dir_id bigint,
    title character varying(255) NOT NULL,
    description text NOT NULL,
    data text NOT NULL
);
CREATE TABLE config_event
(
    event_id bigserial not null constraint config_event_pk primary key,
    event_type character varying(16) NOT NULL,
    event_time bigint NOT NULL,
    event_user_id bigint,
    event_task_id bigint,
    id bigint NOT NULL,
    dir_id bigint,
    title character varying(255) NOT NULL,
    description text NOT NULL,
    data text NOT NULL
);
CREATE INDEX config_event_id_idx ON config_event (id);

CREATE TABLE resource
(
    id bigserial not null constraint resource_pk primary key,
    dir_id bigint,
    task_id bigint,
    title character varying(255),
    meta jsonb NOT NULL,
    key character(40) NOT NULL,
    secret character(24) NOT NULL
);
CREATE UNIQUE INDEX resource_key_idx ON resource (key);
CREATE TABLE resource_event
(
    event_id bigserial not null constraint resource_event_pk primary key,
    event_type character varying(16) NOT NULL,
    event_time bigint NOT NULL,
    event_user_id bigint,
    event_task_id bigint,
    id bigint NOT NULL,
    dir_id bigint,
    task_id bigint,
    title character varying(255) NOT NULL,
    meta jsonb NOT NULL,
    key character(40) NOT NULL,
    secret character(24) NOT NULL
);
CREATE INDEX resource_event_id_idx ON resource_event (id);


CREATE TABLE "role"
(
    "id" serial NOT NULL CONSTRAINT "role_pk" PRIMARY KEY,
    "name" character varying(255) NOT NULL,
    "permissions" jsonb NOT NULL
);
CREATE UNIQUE INDEX "role_name_idx" ON "role" ("name");

CREATE TABLE "role_event"
(
    "event_id" bigserial NOT NULL CONSTRAINT "role_event_pk" PRIMARY KEY,
    "event_type" character varying(16) NOT NULL,
    "event_time" bigint NOT NULL,
    "event_user_id" int,
    "event_task_id" bigint,
    "id" int NOT NULL,
    "name" character varying(255) NOT NULL,
    "permissions" jsonb NOT NULL
);
CREATE INDEX "role_event_id_idx" ON "role_event" ("id");


CREATE TABLE "account_role"
(
    "id" bigserial NOT NULL CONSTRAINT "account_role_pk" PRIMARY KEY,
    "account_id" int NOT NULL,
    "role_id" int NOT NULL
);
CREATE INDEX "account_role_account_id_idx" ON "account_role" ("account_id");
CREATE UNIQUE INDEX "account_role_account_id_role_id_idx" ON "account_role" ("account_id", "role_id");
ALTER TABLE "account_role" ADD CONSTRAINT "account_role_account_id_fk" FOREIGN KEY ("account_id") REFERENCES "account" ("id");
ALTER TABLE "account_role" ADD CONSTRAINT "account_role_role_id_fk" FOREIGN KEY ("role_id") REFERENCES "role" ("id");

CREATE TABLE "account_role_event"
(
    "event_id" bigserial NOT NULL CONSTRAINT "account_role_event_pk" PRIMARY KEY,
    "event_type" character varying(16) NOT NULL,
    "event_time" bigint NOT NULL,
    "event_user_id" int,
    "event_task_id" bigint,
    "id" int NOT NULL,
    "account_id" int NOT NULL,
    "role_id" int NOT NULL
);
CREATE INDEX "account_role_event_id_idx" ON "account_role_event" ("id");


CREATE TABLE "account_node_role"
(
    "id" bigserial NOT NULL CONSTRAINT "account_node_role_pk" PRIMARY KEY,
    "account_id" int NOT NULL,
    "node_id" int NOT NULL,
    "role_id" int NOT NULL
);
CREATE UNIQUE INDEX "account_node_role_account_id_node_id_role_id_idx" ON "account_node_role" ("account_id", "node_id", "role_id");
CREATE INDEX "account_node_role_node_id_idx" ON "account_node_role" ("node_id");
ALTER TABLE "account_node_role" ADD CONSTRAINT "account_node_role_account_id_fk" FOREIGN KEY ("account_id") REFERENCES "account" ("id");
ALTER TABLE "account_node_role" ADD CONSTRAINT "account_node_role_node_id_fk" FOREIGN KEY ("node_id") REFERENCES "node" ("id");
ALTER TABLE "account_node_role" ADD CONSTRAINT "account_node_role_role_id_fk" FOREIGN KEY ("role_id") REFERENCES "role" ("id");

CREATE TABLE "account_node_role_event"
(
    "event_id" bigserial NOT NULL CONSTRAINT "account_node_role_event_pk" PRIMARY KEY,
    "event_type" character varying(16) NOT NULL,
    "event_time" bigint NOT NULL,
    "event_user_id" int,
    "event_task_id" bigint,
    "id" int NOT NULL,
    "account_id" int NOT NULL,
    "node_id" int NOT NULL,
    "role_id" int NOT NULL
);
CREATE INDEX "account_node_role_event_id_idx" ON "account_node_role_event" ("id");

CREATE TABLE "node" (
    "id" serial not null constraint node_pk primary key,
    "node_id" integer,
    "create_time" bigint NOT NULL,
    "name" character varying(255) NOT NULL,
    "description" text NOT NULL,
    "inherit_roles" boolean NOT NULL
);
CREATE UNIQUE INDEX "node_node_id_name_idx" ON "node" ("node_id", "name");
ALTER TABLE "node" ADD CONSTRAINT "node_node_id_fk" FOREIGN KEY ("node_id") REFERENCES "node" ("id");

CREATE TABLE "node_event"
(
    "event_id" bigserial NOT NULL CONSTRAINT "node_event_pk" PRIMARY KEY,
    "event_type" character varying(16) NOT NULL,
    "event_time" bigint NOT NULL,
    "event_user_id" int,
    "event_task_id" bigint,
    "id" int NOT NULL,
    "node_id" integer,
    "create_time" bigint NOT NULL,
    "name" character varying(255) NOT NULL,
    "description" text NOT NULL,
    "inherit_roles" boolean NOT NULL
);
CREATE INDEX "node_event_id_idx" ON "node_event" ("id");

CREATE TABLe "planner_state"
(
    "planner_id" int NOT NULL CONSTRAINT planner_state_pk PRIMARY KEY,
    "next_time" bigint,
    "failure_counter" bigint NOT NULL,
    FOREIGN KEY ("planner_id") REFERENCES "planner" ("id")
);
