import { FC, useEffect } from "react";
import { BrowserRouter, Switch, Route, useLocation } from "react-router-dom";
import Header from "./ui/Header";
import ActionPage from "./pages/ActionPage";
import EditActionPage from "./pages/EditActionPage";
import RunActionPage from "./pages/RunActionPage";
import PlanActionPage from "./pages/PlanActionPage";
import NodePage from "./pages/NodePage";
import CreateNodePage from "./pages/CreateNodePage";
import CreateActionPage from "./pages/CreateActionPage";
import CreateConfigPage from "./pages/CreateConfigPage";
import CreateSecretPage from "./pages/CreateSecretPage";
import EditNodePage from "./pages/EditNodePage";
import IndexPage from "./pages/IndexPage";
import TaskPage from "./pages/TaskPage";
import PlannerPage from "./pages/PlannerPage";
import RunPlannerPage from "./pages/RunPlannerPage";
import EditPlannerPage from "./pages/EditPlannerPage";
import ConfigPage from "./pages/ConfigPage";
import SecretPage from "./pages/SecretPage";
import EditConfigPage from "./pages/EditConfigPage";
import EditSecretPage from "./pages/EditSecretPage";
import ResourcePage from "./pages/ResourcePage";
import NotFoundPage from "./pages/NotFoundPage";
import { TreeListWrap, TreeWrap } from "./ui/Tree";
import HostsPage from "./pages/HostsPage";
import SearchPage from "./pages/SearchPage";


const ScrollToTop = () => {
	const { pathname } = useLocation();
	useEffect(() => {
		window.scrollTo(0, 0);
	}, [pathname]);
	return null;
};

const App: FC = () => {
	return <BrowserRouter>
		<ScrollToTop />
		<Header />
		<main id="body">
			<Switch>
				<Route exact path="/hosts" component={HostsPage} />
				<Route exact path="/search" component={SearchPage} />
				<Route path="*">
					<TreeWrap>
						<aside id="sidebar">
							<TreeListWrap />
						</aside>
						<div id="content">
							<Switch>
								<Route exact path="/" component={IndexPage} />
								<Route exact path="/nodes/:nodeID" component={NodePage} />
								<Route exact path="/nodes/:nodeID/new-node" component={CreateNodePage} />
								<Route exact path="/nodes/:nodeID/new-action" component={CreateActionPage} />
								<Route exact path="/nodes/:nodeID/new-secret" component={CreateSecretPage} />
								<Route exact path="/nodes/:nodeID/new-config" component={CreateConfigPage} />
								<Route exact path="/nodes/:nodeID/edit" component={EditNodePage} />
								<Route exact path="/actions" component={ActionPage} />
								<Route exact path="/actions/:actionID" component={ActionPage} />
								<Route exact path="/actions/:actionID/edit" component={EditActionPage} />
								<Route exact path="/actions/:actionID/run" component={RunActionPage} />
								<Route exact path="/actions/:actionID/plan" component={PlanActionPage} />
								<Route exact path="/planners/:plannerID" component={PlannerPage} />
								<Route exact path="/planners/:plannerID/run" component={RunPlannerPage} />
								<Route exact path="/planners/:plannerID/edit" component={EditPlannerPage} />
								<Route exact path="/configs/:configID" component={ConfigPage} />
								<Route exact path="/configs/:configID/edit" component={EditConfigPage} />
								<Route exact path="/secrets/:secretID" component={SecretPage} />
								<Route exact path="/secrets/:secretID/edit" component={EditSecretPage} />
								<Route exact path="/resources/:ResourceID" component={ResourcePage} />
								<Route exact path="/tasks/:taskID" component={TaskPage} />
								<Route path="*" component={NotFoundPage} />
							</Switch>
						</div>
					</TreeWrap>
				</Route>
			</Switch>
		</main>
	</BrowserRouter>;
};

export default App;
