// OptionType represents type of option.
export enum OptionType {
	INTEGER = "Integer",
	STRING = "String",
	CONFIG = "Config",
	SECRET = "Secret",
}

// TODO(iudovin@): Replace any with all possible types of settings.
export type IOptionSettings = IStringOptionSettings | any;

// TODO(iudovin@): Replace any with all possible types of values.
export type IOptionValue = number | string | any;

// IOption represents option.
export interface IOption {
	Type: OptionType;
	Title?: string;
	Description?: string;
	Settings?: IOptionSettings;
	Value?: IOptionValue;
	Required: boolean;
	Visible: boolean;
	Editable: boolean;
}

// IStringOptionSettings represents settings for option of type "String".
interface IStringOptionSettings {
	Multiline?: boolean;
}

// IAction represents action.
export interface IAction {
	ID: number;
	DirID?: number;
	Title: string;
	Description?: string;
	Options?: {[key: string]: IOption};
};
