import {ITaskOption} from "./tasks";
import {IOption} from "./actions";

export interface IPlannerSettings {
	RepeatDelay?: number;
	FailureDelay?: number;
	Schedule?: string;
	FailureMails?: string[];
	ListenSuccess: number[];
	ListenFailure: number[];
	Enabled: boolean;
	AllowOverlaps: boolean;
};

// IPlanner represents action.
export interface IPlanner {
	ID: number;
	DirID?: number;
	ActionID?: number;
	Title: string;
	Description?: string;
	Options?: {[key: string]: ITaskOption};
	Settings: IPlannerSettings;
};
