import {IAction, OptionType, IOptionValue, IOption} from "./actions";

export interface ITaskOption {
	Type: OptionType;
	Value: IOptionValue;
}

export interface ITask {
	ID: number;
	ActionID: number;
	Options?: {[key: string]: ITaskOption};
}

export interface ITaskWithAction extends ITask {
	Action: IAction;
};

export interface IActionWithTasks extends IAction {
	Tasks?: ITask[];
};
