import { useState, useContext, useEffect } from "react";
import { RouteComponentProps } from "react-router";
import ActionBlock from "../../ui/ActionBlock";
import ActionTasksBlock from "../../ui/ActionTasksBlock";
import { TreeNodeContext } from "../../ui/Tree";
import { IAction, observeAction } from "../../api";

type ActionPageParams = {
	actionID: string;
};

const ActionPage = ({ match }: RouteComponentProps<ActionPageParams>) => {
	const { actionID } = match.params;
	const [action, setAction] = useState<IAction>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedActionID = parseInt(actionID);
	useEffect(() => {
		setAction(undefined);
		observeAction(parsedActionID)
			.then((action: IAction) => {
				setAction(action);
				setTreeNodeID(action.node_id);
			})
			.catch(console.log);
	}, [parsedActionID, setTreeNodeID]);
	if (!action) {
		return <div />;
	}
	return <>
		<ActionBlock action={action} />
		<ActionTasksBlock action={action} />
	</>;
};

export default ActionPage;
