import { useContext, useEffect, useState } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import ConfigBlock from "../../ui/ConfigBlock";
import { RouteComponentProps } from "react-router";
import { observeConfig, Config } from "../../api";

type ConfigPageParams = {
	configID: string;
};

const ConfigPage = ({ match }: RouteComponentProps<ConfigPageParams>) => {
	const { configID } = match.params;
	const [config, setConfig] = useState<Config>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedConfigID = parseInt(configID);
	useEffect(() => {
		setConfig(undefined);
		observeConfig(parsedConfigID)
			.then((config: Config) => {
				setConfig(config);
				setTreeNodeID(config.node_id);
			})
			.catch(console.log);
	}, [parsedConfigID, setTreeNodeID]);
	if (!config) {
		return <div />;
	}
	return <ConfigBlock config={config} />;
};

export default ConfigPage;
