import { useContext, useState } from "react";
import { Redirect, RouteComponentProps } from "react-router";
import { TreeNodeContext } from "../../ui/Tree";
import ActionEditorBlock from "../../ui/ActionEditorBlock";
import { createAction, ErrorResponse, IAction } from "../../api";

type CreateActionPageParams = {
	nodeID: string;
};

const CreateActionPage = ({ match }: RouteComponentProps<CreateActionPageParams>) => {
	const { nodeID } = match.params;
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedNodeID = parseInt(nodeID);
	setTreeNodeID(parsedNodeID);
	const [redirect, setRedirect] = useState<IAction>();
	const [error, setError] = useState<ErrorResponse>();
	if (redirect) {
		return <Redirect to={`/actions/${redirect.id}`} />;
	}
	const onSubmit = (action: IAction) => {
		setError(undefined);
		createAction(action)
			.then(setRedirect)
			.catch(setError);
	};
	return <ActionEditorBlock parentID={parsedNodeID} onSubmit={onSubmit} error={error} />;
};

export default CreateActionPage;
