import { useContext, useState } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import ConfigEditorBlock from "../../ui/ConfigEditorBlock";
import { createConfig, ErrorResponse, Config } from "../../api";
import { Redirect, RouteComponentProps } from "react-router";

type CreateConfigPageParams = {
	nodeID: string;
};

const CreateConfigPage = ({ match }: RouteComponentProps<CreateConfigPageParams>) => {
	const { nodeID } = match.params;
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedNodeID = parseInt(nodeID);
	setTreeNodeID(parsedNodeID);
	const [redirect, setRedirect] = useState<Config>();
	const [error, setError] = useState<ErrorResponse>();
	if (redirect) {
		return <Redirect to={`/configs/${redirect.id}`} />;
	}
	const onSubmit = (config: Config) => {
		setError(undefined);
		createConfig(config)
			.then(setRedirect)
			.catch(setError);
	};
	return <ConfigEditorBlock parentID={parsedNodeID} error={error} onSubmit={onSubmit} />;
};

export default CreateConfigPage;
