import { useContext, useState } from "react";
import { Redirect, RouteComponentProps } from "react-router";
import { Node, ErrorResponse, createNode } from "../../api";
import { TreeNodeContext } from "../../ui/Tree";
import NodeEditorBlock from "../../ui/NodeEditorBlock";

type CreateNodePageParams = {
    nodeID: string,
};

const CreateNodePage = ({ match }: RouteComponentProps<CreateNodePageParams>) => {
    const { nodeID } = match.params;
    const { setTreeNodeID } = useContext(TreeNodeContext);
    const parsedNodeID = parseInt(nodeID);
    setTreeNodeID(parsedNodeID);
    const [redirect, setRedirect] = useState<Node>();
    const [error, setError] = useState<ErrorResponse>();
    if (redirect) {
        return <Redirect to={`/nodes/${parsedNodeID}`} />;
    }
    const onSubmit = (node: Node) => {
        setError(undefined);
        createNode(node)
            .then(setRedirect)
            .catch(setError);
    }
    return <NodeEditorBlock parentID={parsedNodeID} error={error} onSubmit={onSubmit} />;
};

export default CreateNodePage;
