import { useContext, useState } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import SecretEditorBlock from "../../ui/SecretEditorBlock";
import { createSecret, ErrorResponse, Secret } from "../../api";
import { Redirect, RouteComponentProps } from "react-router";

type CreateSecretPageParams = {
	nodeID: string;
};

const CreateSecretPage = ({ match }: RouteComponentProps<CreateSecretPageParams>) => {
	const { nodeID } = match.params;
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedNodeID = parseInt(nodeID);
	setTreeNodeID(parsedNodeID);
	const [redirect, setRedirect] = useState<Secret>();
	const [error, setError] = useState<ErrorResponse>();
	if (redirect) {
		return <Redirect to={`/secrets/${redirect.id}`} />;
	}
	const onSubmit = (secret: Secret) => {
		setError(undefined);
		createSecret(secret)
			.then(setRedirect)
			.catch(setError);
	};
	return <SecretEditorBlock parentID={parsedNodeID} error={error} onSubmit={onSubmit} />;
};

export default CreateSecretPage;
