import { useState, useContext, useEffect } from "react";
import { Redirect, RouteComponentProps } from "react-router";
import { TreeNodeContext } from "../../ui/Tree";
import { ErrorResponse, IAction, observeAction, updateAction } from "../../api";
import ActionEditorBlock from "../../ui/ActionEditorBlock";

type EditActionPageParams = {
	actionID: string;
};

const EditActionPage = ({ match }: RouteComponentProps<EditActionPageParams>) => {
	const { actionID } = match.params;
	const [action, setAction] = useState<IAction>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedActionID = parseInt(actionID);
	const [redirect, setRedirect] = useState<IAction>();
	const [error, setError] = useState<ErrorResponse>();
	useEffect(() => {
		setAction(undefined);
		observeAction(parsedActionID)
			.then((action: IAction) => {
				setAction(action);
				setTreeNodeID(action.node_id);
			})
			.catch(console.log);
	}, [parsedActionID, setTreeNodeID]);
	if (!action) {
		return <div />;
	}
	if (redirect) {
		return <Redirect to={`/actions/${parsedActionID}`} />;
	}
	const onSubmit = (action: IAction) => {
		setError(undefined);
		updateAction(parsedActionID, action)
			.then(setRedirect)
			.catch(setError);
	};
	return <>
		<ActionEditorBlock action={action} parentID={action.node_id} onSubmit={onSubmit} error={error} />
	</>;
};

export default EditActionPage;
