import { useContext, useEffect, useState } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import ConfigEditorBlock from "../../ui/ConfigEditorBlock";
import { RouteComponentProps, Redirect } from "react-router";
import { ErrorResponse, observeConfig, Config, updateConfig } from "../../api";

type EditConfigPageParams = {
	configID: string;
};

const EditConfigPage = ({ match }: RouteComponentProps<EditConfigPageParams>) => {
	const { configID } = match.params;
	const [config, setConfig] = useState<Config>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedConfigID = parseInt(configID);
	const [redirect, setRedirect] = useState<Config>();
	const [error, setError] = useState<ErrorResponse>();
	useEffect(() => {
		setConfig(undefined);
		observeConfig(parsedConfigID)
			.then((config: Config) => {
				setConfig(config);
				setTreeNodeID(config.node_id);
			})
			.catch(console.log);
	}, [parsedConfigID, setTreeNodeID]);
	if (!config) {
		return <div />;
	}
	if (redirect) {
		return <Redirect to={`/configs/${parsedConfigID}`} />;
	}
	const onSubmit = (config: Config) => {
		setError(undefined);
		updateConfig(parsedConfigID, config)
			.then(setRedirect)
			.catch(setError);
	};
	return <ConfigEditorBlock config={config} parentID={config.node_id} error={error} onSubmit={onSubmit} />;
};

export default EditConfigPage;
