import { useContext, useState, useEffect } from "react";
import { Redirect, RouteComponentProps } from "react-router";
import { Node, ErrorResponse, updateNode, observeNode } from "../../api";
import { TreeNodeContext } from "../../ui/Tree";
import NodeEditorBlock from "../../ui/NodeEditorBlock";

type EditNodePageParams = {
    nodeID: string,
};

const EditNodePage = ({ match }: RouteComponentProps<EditNodePageParams>) => {
    const { nodeID } = match.params;
    const { setTreeNodeID } = useContext(TreeNodeContext);
    const parsedNodeID = parseInt(nodeID);
    setTreeNodeID(parsedNodeID);
    const [node, setNode] = useState<Node>();
    useEffect(() => {
        setNode(undefined);
        observeNode(parsedNodeID)
            .then(setNode)
            .catch(console.log);
    }, [parsedNodeID, setTreeNodeID]);
    const [redirect, setRedirect] = useState<Node>();
    const [error, setError] = useState<ErrorResponse>();
    if (!node) {
        return <div />;
    }
    const onSubmit = (node: Node) => {
        setError(undefined);
        updateNode(parsedNodeID, node)
            .then(setRedirect)
            .catch(setError);
    }
    if (redirect) {
        return <Redirect to={`/nodes/${parsedNodeID}`} />;
    }
    return <NodeEditorBlock parentID={parsedNodeID} node={node} error={error} onSubmit={onSubmit} />;
};

export default EditNodePage;
