import { useContext, useEffect, useState } from "react";
import { RouteComponentProps, Redirect } from "react-router";
import { IAction, IPlanner } from "../../api";
import { TreeNodeContext } from "../../ui/Tree";
import PlannerEditorBlock from "../../ui/PlannerEditorBlock";

type PlannerPageParams = {
	plannerID: string;
};

const EditPlannerPage = ({ match }: RouteComponentProps<PlannerPageParams>) => {
	const { plannerID } = match.params;
	const [planner, setPlanner] = useState<IPlanner>();
	const [action, setAction] = useState<IAction>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const [redirect, setRedirect] = useState<boolean>(false);
	useEffect(() => {
		fetch(`/api/v0/planners/${plannerID}`)
			.then(response => response.json())
			.then((planner: IPlanner) => {
				setPlanner(planner);
				setTreeNodeID(planner.node_id);
				return fetch(`/api/v0/actions/${planner.action_id}`);
			})
			.then(response => response.json())
			.then(setAction)
			.catch(console.log);
	}, [plannerID, setTreeNodeID]);
	if (!action || !planner) {
		return <div />;
	}
	const onSubmit = (planner: IPlanner) => {
		fetch(`/api/v0/planners/${plannerID}`, {
			method: "PATCH",
			headers: {
				"Content-Type": "application/json",
			},
			body: JSON.stringify(planner),
		})
			.then(response => response.json())
			.then((planner: IPlanner) => {
				setPlanner(planner);
				setTreeNodeID(planner.node_id);
				setRedirect(true);
			})
			.catch(console.log);
	};
	if (redirect) {
		return <Redirect to={`/planners/${planner.id}`} />;
	}
	return <PlannerEditorBlock action={action} planner={planner} onSubmit={onSubmit} />;
};

export default EditPlannerPage;
