import { useContext, useEffect, useState } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import SecretEditorBlock from "../../ui/SecretEditorBlock";
import { RouteComponentProps, Redirect } from "react-router";
import { ErrorResponse, observeSecret, Secret, updateSecret } from "../../api";

type EditSecretPageParams = {
	secretID: string;
};

const EditSecretPage = ({ match }: RouteComponentProps<EditSecretPageParams>) => {
	const { secretID } = match.params;
	const [secret, setSecret] = useState<Secret>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedSecretID = parseInt(secretID);
	const [redirect, setRedirect] = useState<Secret>();
	const [error, setError] = useState<ErrorResponse>();
	useEffect(() => {
		setSecret(undefined);
		observeSecret(parsedSecretID)
			.then((secret: Secret) => {
				setSecret(secret);
				setTreeNodeID(secret.node_id);
			})
			.catch(console.log);
	}, [parsedSecretID, setTreeNodeID]);
	if (!secret) {
		return <div />;
	}
	if (redirect) {
		return <Redirect to={`/secrets/${parsedSecretID}`} />;
	}
	const onSubmit = (secret: Secret) => {
		setError(undefined);
		updateSecret(parsedSecretID, secret)
			.then(setRedirect)
			.catch(setError);
	};
	return <SecretEditorBlock secret={secret} parentID={secret.node_id} error={error} onSubmit={onSubmit} />;
};

export default EditSecretPage;
