import { useState, useEffect } from "react";
import Block from "../../ui/Block";
import { IGetHostsResp, IHost } from "../../api";
import "./index.scss";

const HostsPage = () => {
	const [hosts, setHosts] = useState<IHost[]>();
	useEffect(() => {
		fetch(`/api/v0/hosts`)
			.then(response => response.json())
			.then((resp: IGetHostsResp) => setHosts(resp.hosts))
			.catch(console.log)
	}, []);
	return <>
		{hosts && hosts.map((host, index) => {
			const tasks = host.state.running_tasks || [];
			return <Block className="ui-block-host" header={<h2 className="title">{host.name}</h2>} key={index}>
				<p className="ping">Ping time: {new Date(host.ping_time * 1000).toUTCString()}</p>
				<ul className="labels">
					{host.running && <li className="success">running</li>}
					{tasks.includes("leader") && <li className="primary">leader</li>}
					{(tasks.includes("runner") || tasks.includes("worker")) && <li className="warning">worker</li>}
					{host.state.labels && Object.entries(host.state.labels).map(([key, value], index) => {
						return <li className="secondary">{key}={value}</li>;
					})}
				</ul>
			</Block>;
		})}
	</>;
};

export default HostsPage;
