import { useContext, useState, useEffect } from "react";
import { RouteComponentProps } from "react-router";
import { Link } from "react-router-dom";
import { Node } from "../../api";
import Block from "../../ui/Block";
import OptionGroup from "../../ui/OptionGroup";
import Markdown from "../../ui/Markdown";
import { TreeNodeContext } from "../../ui/Tree";
import Button from "../../ui/Button";
import "./index.scss";

type NodePageParams = {
	nodeID: string;
};

const NodePage = ({ match }: RouteComponentProps<NodePageParams>) => {
	const { nodeID } = match.params;
	const { setTreeNodeID } = useContext(TreeNodeContext);
	setTreeNodeID(parseInt(nodeID));
	const [node, setNode] = useState<Node>();
	useEffect(() => {
		setNode(undefined);
		fetch(`/api/v0/nodes/${nodeID}`)
			.then(response => response.json())
			.then(setNode)
			.catch(console.log);
	}, [nodeID, setTreeNodeID]);
	if (!node) {
		return <>Loading...</>;
	}
	return <Block
		className="ui-block-node"
		header={<h2 className="title">Node: {node.name}<span className="object-id">ID: {node.id}</span></h2>}
		footer={<>
			<Link to={`/nodes/${node.id}/edit`}><Button>Edit</Button></Link>
			<Button>Remove</Button>
		</>}
	>
		{node.description && <OptionGroup title="Description"><Markdown text={node.description} /></OptionGroup>}
		<OptionGroup title="Create objects">
			<ul className="create-list">
				<li><Link to={`/nodes/${nodeID}/new-node`}>Create <span className="tree-node node">Node</span></Link></li>
				<li><Link to={`/nodes/${nodeID}/new-action`}>Create <span className="tree-node action">Action</span></Link></li>
				<li><Link to={`/nodes/${nodeID}/new-secret`}>Create <span className="tree-node secret">Secret</span></Link></li>
				<li><Link to={`/nodes/${nodeID}/new-config`}>Create <span className="tree-node config">Config</span></Link></li>
			</ul>
		</OptionGroup>
		<OptionGroup title="Permissions">

		</OptionGroup>
	</Block>;
};

export default NodePage;
