import React, {useContext, useEffect, useState} from "react";
import {RouteComponentProps, Redirect} from "react-router";
import {IAction, IPlanner} from "../../api";
import {TreeNodeContext} from "../../ui/Tree";
import PlanActionBlock from "../../ui/PlanActionBlock";

interface PlanActionPageParams {
	actionID: string;
};

const PlanActionPage = ({match}: RouteComponentProps<PlanActionPageParams>) => {
	const {actionID} = match.params;
	const [action, setAction] = useState<IAction>();
	const {setTreeNodeID} = useContext(TreeNodeContext);
	const [redirect, setRedirect] = useState<IPlanner>();
	useEffect(() => {
		fetch(`/api/v0/actions/${actionID}`)
			.then(response => response.json())
			.then((action: IAction) => {
				setAction(action);
				setTreeNodeID(action.node_id);
			})
			.catch(console.log)
	}, [actionID, setTreeNodeID]);
	if (!action) {
		return <div/>;
	}
	const onSubmit = (planner: IPlanner) => {
	    fetch(`/api/v0/actions/${action.id}/plan`, {
	        method: "POST",
            headers: {
	            "Content-Type": "application/json",
            },
            body: JSON.stringify(planner),
        })
            .then(response => response.json())
            .then(setRedirect)
            .catch(console.log);
    };
	if (redirect) {
		return <Redirect to={`/planners/${redirect.id}`} />;
	}
	return <PlanActionBlock action={action} onSubmit={onSubmit}/>;
};

export default PlanActionPage;
