import {useContext, useEffect, useState} from "react";
import {RouteComponentProps} from "react-router";
import {IPlanner} from "../../api";
import {TreeNodeContext} from "../../ui/Tree";
import PlannerBlock from "../../ui/PlannerBlock";
import PlannerTasksBlock from "../../ui/PlannerTasksBlock";

type PlannerPageParams = {
	plannerID: string;
};

const PlannerPage = ({match}: RouteComponentProps<PlannerPageParams>) => {
	const {plannerID} = match.params;
	const [planner, setPlanner] = useState<IPlanner>();
	const {setTreeNodeID} = useContext(TreeNodeContext);
	useEffect(() => {
		fetch(`/api/v0/planners/${plannerID}`)
			.then(response => response.json())
			.then((planner: IPlanner) => {
				setPlanner(planner);
				setTreeNodeID(planner.node_id);
			})
			.catch(console.log)
	}, [plannerID, setTreeNodeID]);
	if (!planner) {
		return <div/>;
	}
	const enablePlanner = () => {
		fetch(`/api/v0/planners/${plannerID}/enable`, {method: "POST"})
			.then(response => response.json())
			.then((planner: IPlanner) => {
				setPlanner(planner);
				setTreeNodeID(undefined);
				setTreeNodeID(planner.node_id);
			})
			.catch(console.log)
	};
	const disablePlanner = () => {
		fetch(`/api/v0/planners/${plannerID}/disable`, {method: "POST"})
			.then(response => response.json())
			.then((planner: IPlanner) => {
				setPlanner(planner);
				setTreeNodeID(undefined);
				setTreeNodeID(planner.node_id);
			})
			.catch(console.log)
	};
	return <>
		<PlannerBlock planner={planner} onEnableClick={enablePlanner} onDisableClick={disablePlanner}/>
		<PlannerTasksBlock planner={planner}/>
	</>;
};

export default PlannerPage;
