import React, {useContext, useEffect, useState} from "react";
import {IResource} from "../../api/resources";
import {TreeNodeContext} from "../../ui/Tree";
import ResourceBlock from "../../ui/ResourceBlock";
import {RouteComponentProps} from "react-router";

interface ResourcePageParams {
	ResourceID: string;
};

const ResourcePage = ({match}: RouteComponentProps<ResourcePageParams>) => {
	const {ResourceID} = match.params;
	const [resource, setResource] = useState<IResource>();
	const {setTreeNodeID} = useContext(TreeNodeContext);
	useEffect(() => {
		fetch(`/api/resources/${ResourceID}`)
			.then(response => response.json())
			.then((resource: IResource) => {
				setResource(resource);
				setTreeNodeID(resource.DirID);
			})
			.catch(console.log)
	}, [ResourceID, setTreeNodeID]);
	if (!resource) {
		return <div/>;
	}
	return <ResourceBlock resource={resource}/>;
};

export default ResourcePage;
