import { useState, useContext, useEffect } from "react";
import { RouteComponentProps, Redirect } from "react-router";
import RunActionBlock from "../../ui/RunActionBlock";
import { TreeNodeContext } from "../../ui/Tree";
import { IAction, ITask, ITaskOptions } from "../../api";

type RunActionPageParams = {
	actionID: string;
};

const RunActionPage = ({ match }: RouteComponentProps<RunActionPageParams>) => {
	const { actionID } = match.params;
	const [action, setAction] = useState<IAction>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const [redirectTask, setRedirectTask] = useState<ITask>();
	useEffect(() => {
		fetch(`/api/v0/actions/${actionID}`)
			.then(response => response.json())
			.then((action: IAction) => {
				setAction(action);
				setTreeNodeID(action.node_id);
			})
			.catch(console.log)
	}, [actionID, setTreeNodeID]);
	if (!action) {
		return <div />;
	}
	const onSubmit = (options: ITaskOptions) => {
		fetch(`/api/v0/actions/${actionID}/run`, {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
			},
			body: JSON.stringify({
				options: options,
			}),
		})
			.then(response => response.json())
			.then(setRedirectTask)
			.catch(console.log);
	};
	if (redirectTask) {
		return <Redirect to={`/tasks/${redirectTask.id}`} />;
	}
	return <RunActionBlock action={action} onSubmit={onSubmit} />;
};

export default RunActionPage;
