import { useState, useContext, useEffect } from "react";
import { RouteComponentProps, Redirect } from "react-router";
import RunPlannerBlock from "../../ui/RunPlannerBlock";
import { TreeNodeContext } from "../../ui/Tree";
import { IAction, IPlanner, ITask, ITaskOptions } from "../../api";

type RunPlannerPageParams = {
	plannerID: string;
};

const RunPlannerPage = ({ match }: RouteComponentProps<RunPlannerPageParams>) => {
	const { plannerID } = match.params;
	const [planner, setPlanner] = useState<IPlanner>();
	const [action, setAction] = useState<IAction>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const [redirectTask, setRedirectTask] = useState<ITask>();
	useEffect(() => {
		fetch(`/api/v0/planners/${plannerID}`)
			.then(response => response.json())
			.then((planner: IPlanner) => {
				setPlanner(planner);
				setTreeNodeID(planner.node_id);
				return fetch(`/api/v0/actions/${planner.action_id}`);
			})
			.then(response => response.json())
			.then((action: IAction) => {
				setAction(action);
			})
			.catch(console.log)
	}, [plannerID, setTreeNodeID]);
	if (!planner || !action) {
		return <div />;
	}
	const onSubmit = (options: ITaskOptions) => {
		fetch(`/api/v0/planners/${plannerID}/run`, {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
			},
			body: JSON.stringify({}),
		})
			.then(response => response.json())
			.then(setRedirectTask)
			.catch(console.log);
	};
	if (redirectTask) {
		return <Redirect to={`/tasks/${redirectTask.id}`} />;
	}
	return <RunPlannerBlock action={action} planner={planner} onSubmit={onSubmit} />;
};

export default RunPlannerPage;
