import React, {useState, useEffect} from "react";
import Block from "../../ui/Block";
import Input from "../../ui/Input";
import {TreeList, ITreeListProps, TreeNode, TreeNodeType} from "../../ui/Tree";
import {RouteComponentProps} from "react-router";
import "./index.scss";

type Action = {
	ID: number;
	Title: string;
	Description?: string;
};

type Planner = {
	ID: number;
	Title: string;
	Description?: string;
	Settings?: any;
};

type TreeListResponse = {
	Actions?: Action[];
	Planners?: Planner[];
};

const SearchPage = ({match, location, history}: RouteComponentProps) => {
	const [state, setState] = useState<ITreeListProps>({});
	let params = new URLSearchParams(location.search);
	const [query, setQuery] = useState<string>(params.get("q") || "");
	useEffect(() => {
		let params = new URLSearchParams(location.search);
		setQuery(params.get("q") || "");
	}, [location.search]);
	useEffect(() => {
		let params = new URLSearchParams({q: query});
		fetch(`/api/v0/search?${params}`)
			.then(response => response.json())
			.then((data: TreeListResponse) => {
				let nodes: TreeNode[] = [];
				const {Actions, Planners} = data;
				Actions && nodes.push(...Actions.map(action => {
					return {
						type: TreeNodeType.ACTION,
						id: action.ID,
						title: action.Title,
						description: action.Description,
					};
				}));
				Planners && nodes.push(...Planners.map(planner => {
					return {
						type: TreeNodeType.PLANNER,
						id: planner.ID,
						title: planner.Title,
						description: planner.Description,
						settings: planner.Settings,
					};
				}));
				let newState: ITreeListProps = {nodes: nodes};
				setState(newState);
			})
    		.catch(console.log)
    }, [query]);
	return <>
		<Block className={"ui-search-input"}>
			<Input value={query} onValueChange={(value) => {
				setQuery(value);
				let params = new URLSearchParams({q: value});
				history.push({pathname: "/search", search: `?${params}`});
			}}/>
		</Block>
		<Block className={"ui-tree-list-wrap"}>
			<TreeList parent={state.parent} nodes={state.nodes}/>
		</Block>
	</>;
};

export default SearchPage;
