import { useContext, useEffect, useState } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import SecretBlock from "../../ui/SecretBlock";
import { RouteComponentProps } from "react-router";
import { observeSecret, Secret } from "../../api";

type SecretPageParams = {
	secretID: string;
};

const SecretPage = ({ match }: RouteComponentProps<SecretPageParams>) => {
	const { secretID } = match.params;
	const [secret, setSecret] = useState<Secret>();
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const parsedSecretID = parseInt(secretID);
	useEffect(() => {
		setSecret(undefined);
		observeSecret(parsedSecretID)
			.then((secret: Secret) => {
				setSecret(secret);
				setTreeNodeID(secret.node_id);
			})
			.catch(console.log);
	}, [parsedSecretID, setTreeNodeID]);
	if (!secret) {
		return <div />;
	}
	return <SecretBlock secret={secret} />;
};

export default SecretPage;
