import { useState, useContext, useEffect } from "react";
import { TreeNodeContext } from "../../ui/Tree";
import TaskBlock from "../../ui/TaskBlock";
import { RouteComponentProps } from "react-router";
import { ITask, IAction, IPlanner, abortTask } from "../../api";

type TaskPageParams = {
	taskID: string;
};

const TaskPage = ({ match }: RouteComponentProps<TaskPageParams>) => {
	const { taskID } = match.params;
	const { setTreeNodeID } = useContext(TreeNodeContext);
	const [task, setTask] = useState<ITask>();
	const [action, setAction] = useState<IAction>();
	const [planner, setPlanner] = useState<IPlanner>();
	useEffect(() => {
		setTask(undefined);
		fetch(`/api/v0/tasks/${taskID}`)
			.then(response => response.json())
			.then((task: ITask) => {
				setTask(task);
			})
			.catch(console.log);
	}, [taskID, setTreeNodeID]);
	const [stderrLogs, setStderrLogs] = useState<string>();
	useEffect(() => {
		setStderrLogs(undefined);
		fetch(`/api/v0/tasks/${taskID}/logs/stderr`)
			.then(response => response.text())
			.then(setStderrLogs)
			.catch(console.log);
	}, [taskID, setTreeNodeID]);
	const [stdoutLogs, setStdoutLogs] = useState<string>();
	useEffect(() => {
		setStdoutLogs(undefined);
		fetch(`/api/v0/tasks/${taskID}/logs/stdout`)
			.then(response => response.text())
			.then(setStdoutLogs)
			.catch(console.log);
	}, [taskID, setTreeNodeID]);
	const [systemLogs, setSystemLogs] = useState<string>();
	useEffect(() => {
		setSystemLogs(undefined);
		fetch(`/api/v0/tasks/${taskID}/logs/system`)
			.then(response => response.text())
			.then(setSystemLogs)
			.catch(console.log);
	}, [taskID, setTreeNodeID]);
	useEffect(() => {
		if (!task) {
			return;
		}
		fetch(`/api/v0/actions/${task.action_id}`)
			.then(response => response.json())
			.then((action: IAction) => {
				setAction(action);
				if (!task.planner_id) {
					setTreeNodeID(action.node_id);
				}
			})
			.catch(console.log);
		if (!!task.planner_id) {
			fetch(`/api/v0/planners/${task.planner_id}`)
				.then(response => response.json())
				.then((planner: IPlanner) => {
					setPlanner(planner);
					setTreeNodeID(planner.node_id);
				})
				.catch(console.log);
		}
	}, [task, setTreeNodeID]);
	if (!task || !action) {
		return <div />;
	}
	const onAbortTask = () => {
		abortTask(task.id).then(setTask).catch(console.log);
	};
	return <TaskBlock task={task} action={action} planner={planner} stderrLogs={stderrLogs} stdoutLogs={stdoutLogs} systemLogs={systemLogs} onAbortTask={onAbortTask} />;
};

export default TaskPage;
