import { FC, Fragment } from "react";
import { Link } from "react-router-dom";
import Block from "../Block";
import Button from "../Button";
import Option from "../Option";
import OptionGroup from "../OptionGroup";
import Markdown from "../Markdown";
import { IAction, IOption } from "../../api";
import "./index.scss";

export interface IActionOptionsBlockProps {
    options: { [key: string]: IOption };
    editable: boolean;
}

export const ActionOptionsBlock: FC<IActionOptionsBlockProps> = props => {
    const { options, editable } = props;
    return <OptionGroup title="Options">
        {Object.entries(options).map(([code, option], index) => {
            if (!option.Visible) {
                return <Fragment key={index} />;
            }
            if (!editable) {
                option = { ...option, Editable: false };
            }
            return <Option option={option} optionCode={code} key={index} />;
        })}
    </OptionGroup>;
};

export interface IActionBlockProps {
    action: IAction;
}

const ActionBlock: FC<IActionBlockProps> = props => {
    const { action } = props;
    return <Block
        className="ui-block-action"
        header={<h2 className="title">Action: {action.title}<span className="object-id">ID: {action.id}</span></h2>}
        footer={<>
            <Link to={`/actions/${action.id}/run`}><Button>Run</Button></Link>
            <Link to={`/actions/${action.id}/plan`}><Button>Plan</Button></Link>
            <Link to={`/actions/${action.id}/edit`}><Button>Edit</Button></Link>
        </>}
    >
        <p>Go to <a href={`/action/${action.id}`}>old interface</a>.</p>
        {action.description && <OptionGroup title="Description"><Markdown text={action.description} /></OptionGroup>}
        {action.options && <ActionOptionsBlock options={action.options} editable={false} />}
    </Block>;
};

export default ActionBlock;
