import React, {BaseHTMLAttributes, FC, ReactNode} from "react";
import "./index.scss";

export type BlockProps = BaseHTMLAttributes<HTMLDivElement> & {
	header?: ReactNode;
	footer?: ReactNode;
};

const Block: FC<BlockProps> = props => {
	const {className, header, footer, children, ...rest} = props;
	let classes = ["ui-block"];
	className && classes.push(className);
	return <div className={classes.join(" ")} {...rest}>
		{header && <div className="header">{header}</div>}
		<div className="body">{children}</div>
		{footer && <div className="footer">{footer}</div>}
	</div>;
};

export default Block;
