import React, {ButtonHTMLAttributes, FC} from "react";
import "./index.scss";

export interface IButtonProps extends
    ButtonHTMLAttributes<HTMLButtonElement> {}

const Button: FC<IButtonProps> = props => {
	const {className, ...rest} = props;
	let classes = ["ui-button"];
	className && classes.push(className);
	return <button className={classes.join(" ")} {...rest}/>;
};

export default Button;
