import { FC } from "react";
import { Link } from "react-router-dom";
import Block from "../Block";
import Button from "../Button";
import Option from "../Option";
import OptionGroup from "../OptionGroup";
import Markdown from "../Markdown";
import { OptionType } from "../../api/actions";
import { Config } from "../../api";

export interface IConfigOptionsBlockProps {
    data: string;
    editable: boolean;
    onDataChange?(data: string): void;
};

export const ConfigOptionsBlock: FC<IConfigOptionsBlockProps> = props => {
    const { data, editable, onDataChange } = props;
    return <OptionGroup title="Data">
        <Option
            option={{
                Type: OptionType.STRING,
                Title: "Data",
                Description: "Data contains config data.",
                Value: data,
                Required: true,
                Visible: true,
                Editable: editable,
                Settings: {
                    Multiline: true,
                }
            }}
            optionCode="Data"
            onValueChange={(value) => onDataChange && onDataChange(value)}
        />
    </OptionGroup>;
};

export interface IConfigBlockProps {
    config: Config;
};

const ConfigBlock: FC<IConfigBlockProps> = props => {
    const { config } = props;
    const { id, title, data } = config;
    return <Block
        header={<h2 className="title">Config: {title}<span className="object-id">ID: {id}</span></h2>}
        footer={<>
            <Link to={`/configs/${id}/edit`}><Button>Edit</Button></Link>
            <Button>Remove</Button>
        </>}
    >
        {config.description && <OptionGroup title="Description"><Markdown text={config.description} /></OptionGroup>}
        {data && <ConfigOptionsBlock data={data} editable={false} />}
    </Block>;
};

export default ConfigBlock;
