import { BaseHTMLAttributes, FC, ReactNode } from "react";
import Notice from "../Notice";
import "./index.scss";

export type FieldProps = BaseHTMLAttributes<HTMLDivElement> & {
    title?: string;
    description?: string | ReactNode;
    error?: string | ReactNode;
};

const Field: FC<FieldProps> = props => {
    const { title, description, error, children, className, ...rest } = props;
    return <div className={`ui-field ${className || ""}`} {...rest}>
        <label>
            {title && <span className="title">{title}</span>}
            {children}
            {description && <span className="description">{description}</span>}
        </label>
        {error && <Notice>{error}</Notice>}
    </div>;
};

export default Field;
