import React, {FC, BaseHTMLAttributes} from "react";
import {Link} from "react-router-dom";
import "./index.scss";

export interface IHeaderProps extends
    BaseHTMLAttributes<HTMLBaseElement> {}

const Header: FC<IHeaderProps> = props => {
	return <header id="header" {...props}>
		<ul>
			<li className="logo">
                <Link to="/">
                    <span className="icon"/>
                    <span className="title">Runner</span>
                </Link>
			</li>
			<li><Link to="/">Navigation</Link></li>
			<li><Link to="/search">Search</Link></li>
			<li><Link to="/hosts">Hosts</Link></li>
		</ul>
	</header>;
};

export default Header;
