import React, { InputHTMLAttributes, FC } from "react";
import "./index.scss";

export interface IInputProps extends InputHTMLAttributes<HTMLInputElement> {
    onValueChange?(value: string): void;
}

const Input: FC<IInputProps> = props => {
    const { value, className, onValueChange, ...rest } = props;
    return <input
        className={`ui-input ${className || ""}`}
        value={value || ""}
        onChange={(event) => onValueChange && onValueChange(event.target.value)}
        {...rest}
    />;
};

export default Input;
