import {BaseHTMLAttributes, FC} from "react";
import "./index.scss";

export enum NoticeKind {
	SUCCESS = "success",
	INFO = "info",
	WARNING = "warning",
	DANGER = "danger",
}

export type NoticeProps = BaseHTMLAttributes<HTMLDivElement> & {
	kind?: NoticeKind;
};

const Notice: FC<NoticeProps> = props => {
	const {kind, children, ...rest} = props;
	return <div className={"ui-notice " + (kind ?? NoticeKind.DANGER)} {...rest}>
		<div className="ui-notice-content">{children}</div>
	</div>;
};

export default Notice;
