import React, { FC } from "react";
import "./index.scss";

// IOptionGroupProps represents props for Option component.
export interface IOptionGroupProps {
	title?: string;
}

// OptionGroup represents option group component.
const OptionGroup: FC<IOptionGroupProps> = props => {
	const { title, children } = props;
	return <div className="ui-option-group">
		<div className="header">
			{title && <h2 className="title">{title}</h2>}
		</div>
		<div className="options">{children}</div>
	</div>;
};

export default OptionGroup;
