import React, { FC, useEffect, useState } from "react";
import { Link } from "react-router-dom";
import Block from "../Block";
import { IPlanner, ITasksResp, ITask } from "../../api";
import Button from "../Button";
import "./index.scss";
import { formatDuration, TaskStatus } from "../TaskBlock";

export interface IPlannerTasksBlockProps {
	planner: IPlanner;
};

const PlannerTasksBlock: FC<IPlannerTasksBlockProps> = props => {
	const { planner } = props;
	const [tasks, setTasks] = useState<ITasksResp>();
	const [loading, setLoading] = useState<boolean>(false);
	const loadMoreTasks = () => {
		setLoading(true);
		tasks && fetch(`/api/v0/planners/${planner.id}/tasks?begin=${tasks.next_begin}`)
			.then(response => response.json())
			.then((newTasks: ITasksResp) => {
				setTasks({
					tasks: (tasks.tasks || []).concat(newTasks.tasks || []),
					next_begin: newTasks.next_begin,
				});
				setLoading(false);
			})
			.catch(console.log)
	};
	useEffect(() => {
		setTasks(undefined);
		fetch(`/api/v0/planners/${planner.id}/tasks`)
			.then(response => response.json())
			.then((tasks: ITasksResp) => {
				setTasks(tasks);
			})
			.catch(console.log)
	}, [planner.id]);
	if (!tasks) {
		return <div />;
	}
	return <Block
		header={<h2 className="title">Planner tasks</h2>}
		className="ui-block-tasks"
		footer={tasks.next_begin && <>{!loading ? <Button onClick={loadMoreTasks}>Load more</Button> : <Button>Loading...</Button>}</>}
	>
		<ul>
			{tasks.tasks && tasks.tasks.map((task: ITask, index: number) => <li className="task" key={index}>
				<TaskStatus status={task.status} />
				<Link to={`/tasks/${task.id}`} className="task-id">{task.id}</Link>
				<span className="task-start-time">{(new Date(task.create_time * 1000)).toString()}</span>
				<span className="task-duration">{formatDuration(task.update_time - task.create_time)}</span>
			</li>)}
		</ul>
	</Block>;
};

export default PlannerTasksBlock;
