import React, {FC} from "react";
import Block from "../Block";
import {IResource} from "../../api/resources";

export interface ResourceBlockProps {
	resource: IResource;
};

const ResourceBlock: FC<ResourceBlockProps> = props => {
	const {resource} = props;
	const {ID, Title} = resource;
	return <Block
		header={<h2 className="title">Resource: {Title}<span className="object-id">ID: {ID}</span></h2>}
	>
		Goto <a href={`/api/resources/${ID}/data`} target="_blank" rel="noopener noreferrer">Data</a>.
	</Block>;
};

export default ResourceBlock;
