import React, {FC, useState} from "react";
import {Link} from "react-router-dom";
import Block from "../Block";
import Button from "../Button";
import {IAction, ITaskOptions} from "../../api";
import {TaskOptionsBlock} from "../TaskBlock";

export interface IRunActionBlockProps {
	action: IAction;
    onSubmit?(task: ITaskOptions): void;
};

const RunActionBlock: FC<IRunActionBlockProps> = props => {
	const {action, onSubmit} = props;
    const [options, setOptions] = useState<ITaskOptions>({});
	return <form onSubmit={(event) => {
        event.preventDefault();
        onSubmit && onSubmit(options);
    }}>
        <Block
            className="ui-block-action"
            header={<h2 className="title">Run action &laquo;<Link to={`/actions/${action.id}`}>{action.title}</Link>&raquo;</h2>}
            footer={<>
                <Button type="submit">Create task</Button>
                <Link to={`/actions/${action.id}`}><Button>Back</Button></Link>
            </>}
        >
            <>Go to <a href={`/action/${action.id}/run`}>old interface</a>.</>
            {action.options && <TaskOptionsBlock options={action.options} taskOptions={options} onTaskOptionsChange={setOptions} editable={true}/>}
        </Block>
    </form>;
};

export default RunActionBlock;
